//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: net.hh
//
// Purpose: models a net that connects two or more device ports together
//
// Remarks: 
//
// History: 03/22/97 - MAR - created.
//	    01/26/04 - STF - Modified for compatibility with g++-3
//
// Copyright (c) 1997 Michael A. Riepe
// Copyright (c) 2004 Stephen T. Frezza
//
// RCS Version:
//     $Id: net.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef __NET__
#define __NET__

// forward declarations
class net;

#ifdef HAVE_STL
   #include <stl>
#else
   #include <stl.h>
#endif
#include "functors.hh"
#include "defs.hh"
#include "port.hh"

//-----------------------------------------------------------------------------
// Class: net
//
// Purpose: 
//-----------------------------------------------------------------------------

class net {
public:

    //-------------------------------------------------------------------------
    // Constructor/destructor.
    //-------------------------------------------------------------------------

    net();
    net(char *name,int number);
    net(net &n);
    virtual ~net();

    // dump contents
    virtual void dump(ostream &os);

    // member access
    inline char *name() { return _name; }
    inline int number() { return _number; }
    inline vector<port*> &terminals() { return _terminals; }
    inline int degree() { return _terminals.size(); }
    inline port &operator[] (int index) { return *_terminals[index]; }
    inline bool &external() { return _external; }
    
    // utilities
    void add_terminal (port &nPort);
    void remove_terminal (port &nPort);

protected:

public:
    char *_name;                                         // the name of the net
    int _number;
    vector<port*> _terminals;          // an array of ports connected to this net

    bool _external;            // external or internal net in hierarchical device
};


#endif // __NET__

/*****************************************************************************/
