//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: port.hh
//
// Purpose: models a port that provides an interface between a device and a wire
//
// Remarks: 
//
// History: 03/22/97 - MAR - created.
//
// Copyright (c) 1997 Michael A. Riepe
//
// RCS Version:
//     $Id: port.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef __PORT__
#define __PORT__

// forward declarations
class port;

#include "net.hh"
#include "device.hh"

//-----------------------------------------------------------------------------
// Class: port
//
// Purpose: 
//-----------------------------------------------------------------------------

class port {
public:

    
    //-------------------------------------------------------------------------
    // Enumerated types in local scope
    //-------------------------------------------------------------------------

    enum dirEnum {_INPUT_, _OUTPUT_, _BIDIR_, _VDD_, _GND_, _UNSPECIFIED_};
    
    //-------------------------------------------------------------------------
    // Constructor/destructor.
    //-------------------------------------------------------------------------

    port();
    port(dirEnum dir);
    port(char *name);
    port(char *name, dirEnum dir);
    port(port &p);
    virtual ~port();

    // dump contents
    virtual void dump(ostream &os);
		friend ostream &operator<<(ostream &os, port &p);

    // member access
    inline char *name() { return _name; }
    inline dirEnum direction() { return _direction; }
    inline net* &net_ref() { return _net_ref; }
    inline device* &device_ref() { return _device_ref; }

protected:

public:
    char *_name;            // the name of this port
    dirEnum _direction;     // the I/O direction of this port
    net *_net_ref;          // the net attached to this port
    device *_device_ref;     // a pointer to the device which contains this port
};


#endif // __PORT__

/*****************************************************************************/
