//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: defs.hh
//
// Purpose: Definition of the basic constants and macros common to most code
//          being developed. 
//
// Remarks: --
//
// History: 06/16/95 - JPMS - created, using definitions commont other programs.
//          12/12/96 - MAR - added RCSID() for rcs keyword substitution.
//
// Copyright (c) 1996 Joao P. Marques Silva.
//
// RCS Version:
//     $Id: defs.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef _COMMON_DEFS
#define _COMMON_DEFS

#include "macros.hh"    // Macros used for consistency checks and debugging

//-----------------------------------------------------------------------------
//
// Declaration of general-purpose constants, macros and enumerated types.
//
//-----------------------------------------------------------------------------

#ifndef _MODDDEF
#define _MODDDEF
#define ODD(x)   ((x % 2) != 0)
#define EVEN(x)  ((x % 2) == 0)
#endif

#ifndef _MMAXDEF
#define _MMAXDEF
#define MAX(a,b) (((a)<(b))?(b):(a))
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif


#ifndef NULL
#define NULL        ((void*)0)
#endif

#ifndef FALSE
#define FALSE       0
#define TRUE        1
#endif

#ifndef NONE
#define NONE        (-1)
#endif

#ifndef ANY
#define ANY         (-2)
#endif

#ifndef ON
#define ON          1
#define OFF         2
#endif

#ifndef ERROR
#define ERROR       0
#define OK          1
#endif

#ifndef INFINITY
#define INFINITY    1000000000
#endif

#ifndef ABORT
#define ABORT       (-2)
#endif

// maximum filename length
#ifndef MAX_FILE_NAME
#define MAX_FILE_NAME 64
#endif

// maximum line buffer size in parsers
#ifndef MAX_LINE_BUFFER
#define MAX_LINE_BUFFER 128
#endif

// maximum length of error/warning message strings
#ifndef MAX_ERRMSG_STR 
#define MAX_ERRMSG_STR 1024
#endif

#endif  // COMMON_DEFS

/*****************************************************************************/

