using System;
using System.Windows.Forms;
using XCircuit;

namespace XCircuitTest
{
	public class BasicFormTest : Form
	{
		public BasicFormTest() : base()
		{
			Text = "Basic XCircuit Forms Test";
			ClientSize = new System.Drawing.Size(100, 400);

			Button arcbtn = new Button();
			arcbtn.Text = "Arc";
			arcbtn.Top = 10;
			arcbtn.Left = 10;
			arcbtn.Width = ClientSize.Width-20;
			arcbtn.Click += new EventHandler(DoArc);
			Controls.Add(arcbtn);

			Button polybtn = new Button();
			polybtn.Text = "Polygon";
			polybtn.Top = arcbtn.Bottom+10;
			polybtn.Left = arcbtn.Left;
			polybtn.Width = arcbtn.Width;
			polybtn.Click += new EventHandler(DoPolygon);
			Controls.Add(polybtn);

			Button boxbtn = new Button();
			boxbtn.Text = "Box";
			boxbtn.Top = polybtn.Bottom+10;
			boxbtn.Left = polybtn.Left;
			boxbtn.Width = polybtn.Width;
			boxbtn.Click += new EventHandler(DoBox);
			Controls.Add(boxbtn);
		}

		public void DoArc(object sender, EventArgs args)
		{
			XCircuit.Application.AutoRefresh = false;

			XCircuit.Arc a = new XCircuit.Arc(0, 0, 100);
			a.Color = System.Drawing.Color.Chocolate;
			a.Style = XCircuit.LineStyle.Dashed;
			a.Closed = false;
			a.LineWidth = 2.0f;
			a.Center.X = 50;
			a.Center.Y += 150;
			a.XRadius = 200;

			XCircuit.Application.AutoRefresh = true;
		}

		public void DoPolygon(object sender, EventArgs args)
		{
			XCircuit.Application.AutoRefresh = false;

			XCircuit.Polygon p = new XCircuit.Polygon(new object[] { 0, 0, 100, 100, 100, 200 });
			p.Points[0].X = -50;
			p.Points.Add(-100, 200);
			p.Closed = true;
			try {
				p.Points[4].Y = 400;
			} catch (System.Runtime.InteropServices.COMException e) {
				if (e.ErrorCode != -2146827682)
					throw e;
			}

			XCircuit.Application.AutoRefresh = true;
		}

		public void DoBox(object sender, EventArgs args)
		{
			XCircuit.Application.AutoRefresh = false;

			XCircuit.Box b = new XCircuit.Box(-100, -200, 250, 100);
			b.Color = System.Drawing.Color.Red;
			b.Style = XCircuit.LineStyle.Dotted;
			b.LineWidth = 3.0f;
			b.Select();

			XCircuit.Application.AutoRefresh = true;
		}

		public static void XC_init()
		{
			BasicFormTest ft = new BasicFormTest();
			ft.Show();
		}
	}
}
