; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "XCircuit"
!define PRODUCT_VERSION "3.4.10"
!define PRODUCT_PUBLISHER "Tim Edwards"
!define PRODUCT_WEB_SITE "http://opencircuitdesign.com/xcircuit/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\xcircuit.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYRIGHT"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\xcircuit.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup.exe"
InstallDir "$PROGRAMFILES\XCircuit"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "xcircuit.exe"
  CreateDirectory "$SMPROGRAMS\XCircuit"
  CreateShortCut "$SMPROGRAMS\XCircuit\XCircuit.lnk" "$INSTDIR\xcircuit.exe"
  CreateShortCut "$DESKTOP\XCircuit.lnk" "$INSTDIR\xcircuit.exe"
  SetOverwrite try
  File "lib\analog.lps"
  File "lib\analoglib2.lps"
  File "lib\asg_spice.lps"
  File "lib\avlsi.lps"
  File "lib\digital.lps"
  SetOutPath "$INSTDIR\fonts"
  File "lib\fonts\courier.lps"
  File "lib\fonts\courier.xfe"
  File "lib\fonts\courieriso.xfe"
  File "lib\fonts\courieriso2.lps"
  File "lib\fonts\courieriso2.xfe"
  File "lib\fonts\courieriso5.lps"
  File "lib\fonts\courieriso5.xfe"
  File "lib\fonts\fonttest.ps"
  File "lib\fonts\helvetica.lps"
  File "lib\fonts\helvetica.xfe"
  File "lib\fonts\helveticaiso.xfe"
  File "lib\fonts\helveticaiso2.lps"
  File "lib\fonts\helveticaiso2.xfe"
  File "lib\fonts\helveticaiso5.lps"
  File "lib\fonts\helveticaiso5.xfe"
  File "lib\fonts\letters.ps"
  File "lib\fonts\myfont.lps"
  File "lib\fonts\myfont.xfe"
  File "lib\fonts\symbol.lps"
  File "lib\fonts\symbol.xfe"
  File "lib\fonts\times_roman.lps"
  File "lib\fonts\times_roman.xfe"
  File "lib\fonts\times_romaniso.xfe"
  File "lib\fonts\times_romaniso2.lps"
  File "lib\fonts\times_romaniso2.xfe"
  File "lib\fonts\times_romaniso5.lps"
  File "lib\fonts\times_romaniso5.xfe"
  SetOutPath "$INSTDIR"
  File "lib\generic.lps"
  File "lib\ic_templates.lps"
  File "lib\lgf.lps"
  File "lib\musiclib.lps"
  File "lib\pcb.lps"
  File "lib\pcb_layout.lps"
  File "lib\quadparts.lps"
  File "lib\series74xx.lps"
  File "lib\signal.lps"
  File "lib\startup.script"
  File "lib\xcircps2.pro"
  File "XCircuit.dll"
  File "XCircuit.COM.dll"
  SetOutPath "$INSTDIR\examples"
  File "examples\analog1.ps"
  File "examples\analog2.ps"
  File "examples\analoglib1.lps"
  File "examples\border.ps"
  File "examples\buses.ps"
  File "examples\diffamp_test2.ps"
  File "examples\diffamp_test3.ps"
  File "examples\diffamp_test.ps"
  File "examples\envelope.ps"
  File "examples\FlareLED.ps"
  File "examples\fourttest.ps"
  File "examples\logic8.ps"
  File "examples\logic.sim"
  File "examples\prelude.ps"
  File "examples\systemd1.lgf"
  File "examples\threestage.ps"
  File "examples\USAflag.ps"
  File "examples\vcoblock.ps"
  File "examples\xcclock.ps"
  SetOutPath "$INSTDIR\examples\win32"
  File "examples\win32\test1.js"
  File "examples\win32\test2.js"
  File "examples\win32\test3.js"
  File "examples\win32\test4.js"
  File "examples\win32\test_event.js"
  File "examples\win32\test_event.vbs"
  File "xccom2\zoomtest.cs"
  File "xccom2\zoomtest.dll"
  File "xccom2\baseformtest.cs"
  File "xccom2\baseformtest.dll"
  File "xccom2\comtest.cs"
  File "xccom2\comtest.dll"
  File "xccom2\colorchooser.cs"
  File "xccom2\colorchooser.dll"
  File "xccom2\colorchooser2.cs"
  File "xccom2\colorchooser2.dll"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\XCircuit\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\XCircuit\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\xcircuit.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\xcircuit.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\xcircps2.pro"
  Delete "$INSTDIR\startup.script"
  Delete "$INSTDIR\signal.lps"
  Delete "$INSTDIR\series74xx.lps"
  Delete "$INSTDIR\quadparts.lps"
  Delete "$INSTDIR\pcb_layout.lps"
  Delete "$INSTDIR\pcb.lps"
  Delete "$INSTDIR\musiclib.lps"
  Delete "$INSTDIR\lgf.lps"
  Delete "$INSTDIR\ic_templates.lps"
  Delete "$INSTDIR\generic.lps"
  Delete "$INSTDIR\fonts\times_romaniso5.xfe"
  Delete "$INSTDIR\fonts\times_romaniso5.lps"
  Delete "$INSTDIR\fonts\times_romaniso2.xfe"
  Delete "$INSTDIR\fonts\times_romaniso2.lps"
  Delete "$INSTDIR\fonts\times_romaniso.xfe"
  Delete "$INSTDIR\fonts\times_roman.xfe"
  Delete "$INSTDIR\fonts\times_roman.lps"
  Delete "$INSTDIR\fonts\symbol.xfe"
  Delete "$INSTDIR\fonts\symbol.lps"
  Delete "$INSTDIR\fonts\myfont.xfe"
  Delete "$INSTDIR\fonts\myfont.lps"
  Delete "$INSTDIR\fonts\letters.ps"
  Delete "$INSTDIR\fonts\helveticaiso5.xfe"
  Delete "$INSTDIR\fonts\helveticaiso5.lps"
  Delete "$INSTDIR\fonts\helveticaiso2.xfe"
  Delete "$INSTDIR\fonts\helveticaiso2.lps"
  Delete "$INSTDIR\fonts\helveticaiso.xfe"
  Delete "$INSTDIR\fonts\helvetica.xfe"
  Delete "$INSTDIR\fonts\helvetica.lps"
  Delete "$INSTDIR\fonts\fonttest.ps"
  Delete "$INSTDIR\fonts\courieriso5.xfe"
  Delete "$INSTDIR\fonts\courieriso5.lps"
  Delete "$INSTDIR\fonts\courieriso2.xfe"
  Delete "$INSTDIR\fonts\courieriso2.lps"
  Delete "$INSTDIR\fonts\courieriso.xfe"
  Delete "$INSTDIR\fonts\courier.xfe"
  Delete "$INSTDIR\fonts\courier.lps"
  Delete "$INSTDIR\digital.lps"
  Delete "$INSTDIR\avlsi.lps"
  Delete "$INSTDIR\asg_spice.lps"
  Delete "$INSTDIR\analoglib2.lps"
  Delete "$INSTDIR\analog.lps"
  Delete "$INSTDIR\xcircuit.exe"
  Delete "$INSTDIR\XCircuit.dll"
  Delete "$INSTDIR\XCircuit.COM.dll"
  Delete "$INSTDIR\examples\analog1.ps"
  Delete "$INSTDIR\examples\analog2.ps"
  Delete "$INSTDIR\examples\analoglib1.lps"
  Delete "$INSTDIR\examples\border.ps"
  Delete "$INSTDIR\examples\buses.ps"
  Delete "$INSTDIR\examples\diffamp_test2.ps"
  Delete "$INSTDIR\examples\diffamp_test3.ps"
  Delete "$INSTDIR\examples\diffamp_test.ps"
  Delete "$INSTDIR\examples\envelope.ps"
  Delete "$INSTDIR\examples\FlareLED.ps"
  Delete "$INSTDIR\examples\fourttest.ps"
  Delete "$INSTDIR\examples\logic8.ps"
  Delete "$INSTDIR\examples\logic.sim"
  Delete "$INSTDIR\examples\prelude.ps"
  Delete "$INSTDIR\examples\systemd1.lgf"
  Delete "$INSTDIR\examples\threestage.ps"
  Delete "$INSTDIR\examples\USAflag.ps"
  Delete "$INSTDIR\examples\vcoblock.ps"
  Delete "$INSTDIR\examples\xcclock.ps"
  Delete "$INSTDIR\examples\win32\test1.js"
  Delete "$INSTDIR\examples\win32\test2.js"
  Delete "$INSTDIR\examples\win32\test3.js"
  Delete "$INSTDIR\examples\win32\test4.js"
  Delete "$INSTDIR\examples\win32\test_event.js"
  Delete "$INSTDIR\examples\win32\test_event.vbs"
  Delete "$INSTDIR\examples\win32\zoomtest.cs"
  Delete "$INSTDIR\examples\win32\zoomtest.dll"
  Delete "$INSTDIR\examples\win32\baseformtest.cs"
  Delete "$INSTDIR\examples\win32\baseformtest.dll"
  Delete "$INSTDIR\examples\win32\comtest.cs"
  Delete "$INSTDIR\examples\win32\comtest.dll"
  Delete "$INSTDIR\examples\win32\colorchooser.cs"
  Delete "$INSTDIR\examples\win32\colorchooser.dll"
  Delete "$INSTDIR\examples\win32\colorchooser2.cs"
  Delete "$INSTDIR\examples\win32\colorchooser2.dll"

  Delete "$SMPROGRAMS\XCircuit\Uninstall.lnk"
  Delete "$SMPROGRAMS\XCircuit\Website.lnk"
  Delete "$DESKTOP\XCircuit.lnk"
  Delete "$SMPROGRAMS\XCircuit\XCircuit.lnk"

  RMDir "$SMPROGRAMS\XCircuit"
  RMDir "$INSTDIR\fonts"
  RMDir "$INSTDIR\examples\win32"
  RMDir "$INSTDIR\examples"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
