#include "XCArc.h"
#include "XCPoint.h"

#undef QUERY_CODE
#define QUERY_CODE XCLINEOBJ_QUERY_CODE

BEGIN_XC_IMPL(XCArc)

PROPERTY_IMPL2(XCArc, r, radius, short, TOARC,
		if (TOARC(&handle)->radius != TOARC(&handle)->yaxis)
			return ECODE(XC_E_ARCNOTCIRCLE);,
		TOARC(&handle)->yaxis = newVal;
)
PROPERTY_IMPL(XCArc, rx, radius, short, TOARC)
PROPERTY_IMPL(XCArc, ry, yaxis, short, TOARC)
/*
PROPERTY_IMPL(XCArc, cx, position.x, short, TOARC)
PROPERTY_IMPL(XCArc, cy, position.y, short, TOARC)
*/
PROPERTY_IMPL2(XCArc, start, angle1, float, TOARC,
		;,
		if (TOARC(&handle)->angle2 < newVal)
			return ECODE(XC_E_ARCINVALIDANGLES);
)
PROPERTY_IMPL2(XCArc, stop, angle2, float, TOARC,
		;,
		if (newVal < TOARC(&handle)->angle1)
			return ECODE(XC_E_ARCINVALIDANGLES);
)

STDMETHODIMP XCArc_get_center(IXCArc *This, IXCPoint **pt)
{
	HRESULT hres;
	long handle;
	XCPoint *point;

	if ((hres = IXCArc_get_object_handle(This, &handle)) != S_OK)
		return hres;
	point = (XCPoint*)make_XCPoint();
	IXCArc_QueryInterface(This, &IID_IXCObject, &point->object);
	point->pt = &TOARC(&handle)->position;

	IXCPoint_QueryInterface(&point->iface, &IID_IXCPoint, (void**)pt);

	return S_OK;
}

XCLINEOBJ_VTBL_BEGIN(XCArc)
	XCArc_get_r,
	XCArc_put_r,
	XCArc_get_rx,
	XCArc_put_rx,
	XCArc_get_ry,
	XCArc_put_ry,
	/*
	XCArc_get_cx,
	XCArc_put_cx,
	XCArc_get_cy,
	XCArc_put_cy,
	*/
	XCArc_get_start,
	XCArc_put_start,
	XCArc_get_stop,
	XCArc_put_stop,
	XCArc_get_center,
XCLINEOBJ_VTBL_END()

END_XC_IMPL(XCArc)
