/*----------------------------------------------------------------------*/
/* prototypes.h:							*/
/*     Master list of function prototypes				*/
/*----------------------------------------------------------------------*/

/* from undo.c */

/* Note variable argument list for register_for_undo() */
extern void register_for_undo(u_int, u_char, objinstptr, ...);
extern void undo_action();
extern void redo_action();
extern void flush_undo_stack();
extern void flush_redo_stack();
extern void truncate_undo_stack();
extern void free_undo_record(Undoptr);
extern void free_redo_record(Undoptr);
extern stringpart *get_original_string(labelptr);
extern short *recover_selectlist(Undoptr);
#ifndef TCL_WRAPPER
extern void undo_call(xcWidget, caddr_t, caddr_t);
extern void redo_call(xcWidget, caddr_t, caddr_t);
#endif


/* from tclxcircuit.c */

#ifdef TCL_WRAPPER
extern Tk_EventProc *xctk_drag(ClientData, XEvent *);
extern Tk_EventProc *xctk_draglscroll(ClientData, XEvent *);
extern Tk_EventProc *xctk_dragfilebox(ClientData, XEvent *);
extern int XcTagCallback(Tcl_Interp *, int, Tcl_Obj *CONST objv[]);
extern Tcl_Obj *evaluate_raw(oparamptr, int *);
extern char *TCL_to_PS(char *);
#endif

extern char *evaluate_expr(oparamptr, objinstptr);

/* from opengl.c:  compatibility functions for OpenGL/X11 */

#ifdef OPENGL
extern void SetForeground(Display *, GC, int);
extern void SetBackground(Display *, GC, int);
extern void SetFunction(Display *, GC, int);
extern void SetLineAttributes(Display *, GC, float, int, int, int);
extern void SetDashes(Display *, GC, int, char dashlist[], int);
extern void SetStipple(Display *, GC, int);
extern void SetFillStyle(Display *, GC, int);
extern void DrawLine(Display *, Window, GC, int, int, int, int);
extern void DrawLines(Display *, Window, GC, XPoint *, int, int);
extern void DrawPoint(Display *, Window, GC, int, int);
extern void FillPolygon(Display *, Window, GC, XPoint *, int, int, int);
#endif

/* from elements.c: */

/* element constructor functions */
extern labelptr new_label(objinstptr, stringpart *, int, int, int);
extern labelptr new_simple_label(objinstptr, char *, int, int, int);
extern labelptr new_temporary_label(objectptr, char *, int, int);
extern polyptr new_polygon(objinstptr, pointlist *, int);
extern splineptr new_spline(objinstptr, pointlist);
extern arcptr new_arc(objinstptr, int, int, int);
extern objinstptr new_objinst(objinstptr, objinstptr, int, int);

/* element destructor function */
extern void remove_element(objinstptr, genericptr);

/* functions to set default values for element types */
extern void polydefaults(polyptr, int, int, int);
extern void splinedefaults(splineptr, int, int);
extern void arcdefaults(arcptr, int, int);
extern void pathdefaults(pathptr, int, int);
extern void instancedefaults(objinstptr, objectptr, int, int);
extern void labeldefaults(labelptr, u_char, int, int);

extern void poly_add_point(polyptr, XPoint *);
extern void drawdot(int, int);
extern void copyalleparams(genericptr, genericptr);
extern void copyparams(objinstptr, objinstptr);

extern void textbutton(u_char, int, int);
extern void charreport(labelptr);
extern Boolean labeltext(int, char *);
extern void textreturn();
extern void rejustify(short);
extern void finddir(polyptr);
extern void reversepoints(XPoint *, short);
extern void reversefpoints(XfPoint *, short);
extern void freeparts(short *, short);
extern void removep(short *, short);
extern void unjoin();
extern labelptr findlabelcopy(labelptr, stringpart *);
extern Boolean neartest(XPoint *, XPoint *);
extern void join();

/* interactive manipulation of elements */
extern void splinebutton(int, int);
extern void trackspline(xcWidget, caddr_t, caddr_t);
extern void arcbutton(int, int);
extern void trackarc(xcWidget, caddr_t, caddr_t);
extern void boxbutton(int, int);
extern void trackbox(xcWidget, caddr_t, caddr_t);
extern void trackwire(xcWidget, caddr_t, caddr_t);
extern void startwire(XPoint);
extern void trackpoly(xcWidget, caddr_t, caddr_t);
extern void setendpoint(short *, short, XPoint **, XPoint *);
extern void wire_op(int, int ,int);

/* from events.c: */

extern Boolean recursefind(objectptr, objectptr);
extern void transferselects();
extern void newmatrix();
extern void setpage(Boolean);
extern int changepage(short);
extern void newpage(short);
extern void pushobject(objinstptr);
extern void push_stack(pushlistptr *, objinstptr);
extern void pop_stack(pushlistptr *);
extern void free_stack(pushlistptr *);
extern void popobject(xcWidget, pointertype, caddr_t);
extern void resetbutton(xcWidget, pointertype, caddr_t);
extern void drawhbar(xcWidget, caddr_t, caddr_t);
extern void drawvbar(xcWidget, caddr_t, caddr_t);
extern void panhbar(xcWidget, caddr_t, XButtonEvent *);
extern void endhbar(xcWidget, caddr_t, XButtonEvent *);
extern void panvbar(xcWidget, caddr_t, XButtonEvent *);
extern void endvbar(xcWidget, caddr_t, XButtonEvent *);
extern void zoombox(xcWidget, caddr_t, caddr_t);
extern void zoomin(int, int);
extern void zoomout(int, int);
extern void warppointer(int, int);
extern void panbutton(u_int, int, int, float);
extern void zoominrefresh(int, int);
extern void zoomoutrefresh(int, int);
extern void panrefresh(u_int, int, int, float);
extern void checkwarp(XPoint *);
extern int checkcycle(short, short);
extern void copyvirtual();
extern void nextpolycycle(polyptr, short);
extern void nextsplinecycle(splineptr, short);
extern void nextarccycle(arcptr, short);
extern void buttonhandler(xcWidget, caddr_t, XButtonEvent *);
extern void keyhandler(xcWidget, caddr_t, XKeyEvent *);
extern Boolean compatible_function(int);
extern void eventdispatch(int, int, int);
extern void releasehandler(xcWidget, caddr_t, XKeyEvent *);
extern void setsnap(short);
extern void snapelement();
extern int ipow10(int);
extern int calcgcf(int, int);
extern void fraccalc(float, char *);
extern void printpos(short, short);
extern void findwirex(XPoint *, XPoint *, XPoint *, XPoint *, int *);
extern void findattach(XPoint *, int *, XPoint *);
extern XPoint *pathclosepoint(pathptr, XPoint *);
extern void placeselects(short, short, XPoint *);
extern void drag(int, int);
extern void xlib_drag(xcWidget, caddr_t, XEvent *);
extern void elemrotate(genericptr *, short);
extern void elementrotate(short);
extern void edit(int, int);
extern void pathedit(genericptr *, short);
extern void xc_lower(short *);
extern void xc_raise(short *);
extern void exchange();
extern void elhflip(genericptr *);
extern void elvflip(genericptr *);
extern void elementflip();
extern void elementvflip();
#ifdef TCL_WRAPPER
extern xcTimeOutProc makepress(caddr_t);
#else
extern xcTimeOutProc makepress(caddr_t, xcIntervalId *);
#endif
extern void reviseselect(short *, int, short *);
extern void deletebutton(int, int);
extern short *xc_undelete(objinstptr, objectptr, short, short *);
extern objectptr delete_element(objinstptr, short *, int, short);
extern void printname(objectptr);
extern Boolean checkname(objectptr);
extern char *checkpostscriptname(char *, int *, objectptr);
extern objectptr finddot();
extern void movepoints(genericptr *, short, short);
#ifndef TCL_WRAPPER
extern void xlib_makeobject(xcWidget, caddr_t);
#endif
extern void domakeobject(int);
extern void selectsave(xcWidget, caddr_t, caddr_t);
extern void arceditpush(arcptr);
extern void splineeditpush(splineptr);
extern void polyeditpush(polyptr);
extern pointlist copypoints(pointlist, int);
extern void labelcopy(labelptr, labelptr);
extern void arccopy(arcptr, arcptr);
extern void polycopy(polyptr, polyptr);
extern void splinecopy(splineptr, splineptr);
extern void instcopy(objinstptr, objinstptr);
extern void copy_op(int, int, int);
extern Boolean checkmultiple(XButtonEvent *);
extern void continue_op(int, int, int);
extern void finish_op(int, int, int);
extern void path_op(genericptr *, int, int, int);
extern void resizearea(xcWidget, caddr_t, caddr_t);
extern void drawarea(xcWidget, caddr_t, caddr_t);
extern void standard_element_delete(short);
extern void delete_for_xfer(short, short *, int);
extern void delete_noundo(short);

/* from filelist.c: */

extern int fcompare(const void *, const void *);
extern void dragfilebox(xcWidget, caddr_t, XMotionEvent *);
extern void startfiletrack(xcWidget, caddr_t, XCrossingEvent *);
extern void endfiletrack(xcWidget, caddr_t, XCrossingEvent *);
extern char *getcrashfilename();
extern void crashrecover();
extern void findcrashfiles();
extern void listfiles(xcWidget, popupstruct *, caddr_t);
extern void newfilelist(xcWidget, popupstruct *);
extern void fileselect(xcWidget, popupstruct *, XButtonEvent *);
extern void showlscroll(xcWidget, caddr_t, caddr_t);
extern void draglscroll(xcWidget, popupstruct *, XButtonEvent *);
extern void genfilelist(xcWidget, popupstruct *, Dimension);
extern int lookdirectory(char *);

/* from files.c: */

#ifdef ASG
extern void importspice();
#endif

extern char *ridnewline(char *);
extern void free_single(genericptr);
extern void reset(objectptr, short);
extern void pagereset(short);
extern void initmem(objectptr);
extern void freelabel(stringpart *);
extern Boolean compare_single(genericptr *, genericptr *);
extern Boolean elemcompare(genericptr *, genericptr *);
extern short objcompare(objectptr, objectptr);
extern float getpsscale(float, short);
extern void dostcount(FILE *, short *, short);
extern short printparams(FILE *, objinstptr, short);
extern void printobjectparams(FILE *, objectptr);
extern void varcheck(FILE *, short, objectptr, short *, genericptr, u_char);
extern void varfcheck(FILE *, float, objectptr, short *, genericptr, u_char);
extern void varpcheck(FILE *, short, objectptr, int, short *, genericptr, u_char);
extern void getfile(xcWidget, pointertype, caddr_t);
extern Boolean nextfilename();
extern void loadfontlib();
extern void loadglib(Boolean, short, short);
extern void loadulib();
extern void loadblib();
extern void getlib(xcWidget, caddr_t, caddr_t);
extern void getuserlib(xcWidget, caddr_t, caddr_t);
extern void loadlibrary(short);
extern void startloadfile();
extern void importfile();
extern void loadfile(short);
extern void readlabel(objectptr, char *, stringpart **);
extern void readparams(objectptr, objinstptr, objectptr, char *);
extern u_char *find_match(u_char *);
extern char *advancetoken(char *);
extern char *varpscan(objectptr, char *, short *, genericptr, int, int, u_char);
extern char *varscan(objectptr, char *, short *, genericptr, u_char);
extern char *varfscan(objectptr, char *, float *, genericptr, u_char);
extern objinstptr addtoinstlist(int, objectptr, Boolean);
extern Boolean objectread(FILE *, objectptr, short, short, short, char *, int);
void importfromlibrary(short, char *, char *);
objectptr *new_library_object(short, char *, objlistptr *);
Boolean library_object_unique(short, objectptr, objlistptr);
void add_object_to_library(short, objectptr);
u_char *find_delimiter(u_char *);
char standard_delimiter_end(char);

#ifdef TCL_WRAPPER
void setfile(char *, int);
extern xcTimeOutProc savetemp(caddr_t);
#else
extern void setfile(xcWidget, xcWidget, caddr_t);
extern xcTimeOutProc savetemp(caddr_t, xcIntervalId *);
#endif
extern void savelibpopup(xcWidget, pointertype, caddr_t);
extern void savelibrary(xcWidget, int);
extern void findfonts(objectptr, short *);
extern void savefile(short);
extern int printRGBvalues(char *, int, const char *);
extern char *nosprint(char *);
extern Boolean xc_tilde_expand(char *);
extern short writelabel(FILE *, stringpart *, short *);
extern char *writesegment(stringpart *, float *, int *);
extern int writelabelsegs(FILE *, short *, stringpart *);
extern void printobjects(FILE *, objectptr, objectptr **, short *, int);
extern void printrefobjects(FILE *, objectptr, objectptr **, short *);
extern void printpageobject(FILE *, objectptr, short, short);


/* from fontfile.c: */

extern FILE *findfontfile(char *);
extern int loadfontfile(char *);

/* from formats.c: */

extern void loadlgf(int);
extern void loadmat4(caddr_t);

/* from functions.c: */

extern long sqwirelen(XPoint *, XPoint *);
extern float fsqwirelen(XfPoint *, XfPoint *);
extern int wirelength(XPoint *, XPoint *);
extern long finddist(XPoint *,XPoint *, XPoint *);
extern void calcarc(arcptr);
extern void initsplines();
extern void computecoeffs(splineptr, float *, float *, float *, float *,
                          float *, float *);
extern void calcspline(splineptr);
extern void findsplinepos(splineptr, float, XPoint *, int *);
extern void ffindsplinepos(splineptr, float, XfPoint *);
extern float findsplinemin(splineptr, XPoint *);
extern short closepoint(polyptr, XPoint *);
extern short closedistance(polyptr, XPoint *);
extern void updateinstparam(objectptr);
extern short checkbounds();
extern void window_to_user(short, short, XPoint *);
extern void user_to_window(XPoint, XPoint *);
extern float UTopScale();
extern float UTopTransScale(float);
extern XPoint UGetCursor();
extern XPoint UGetCursorPos();
extern void u2u_snap(XPoint *);
extern void snap(short, short, XPoint *);
extern void UResetCTM(Matrix *);
extern void InvertCTM(Matrix *);
extern void UCopyCTM(Matrix *, Matrix *);
extern void UMakeWCTM(Matrix *);
extern void UMultCTM(Matrix *, XPoint, float, short);
extern void USlantCTM(Matrix *, float);
extern void UPreScaleCTM(Matrix *);
extern short flipadjust(short);
extern void UPreMultCTM(Matrix *, XPoint, float, short);
extern void UTransformbyCTM(Matrix *, XPoint *, XPoint *, short);
extern void UfTransformbyCTM(Matrix *, XfPoint *, XPoint *, short);
extern void UPopCTM(void);
extern void UPushCTM(void);
extern void UTransformPoints(XPoint *, XPoint *, short, XPoint, float,
                             short);
extern void InvTransformPoints(XPoint *, XPoint *, short, XPoint, float,
                             short);
extern void manhattanize(XPoint *, polyptr);
extern void bboxcalc(short, short *, short *);
extern void calcextents(genericptr *, short *, short *, short *, short *);
extern void objinstbbox(objinstptr, XPoint *, Boolean);
extern void labelbbox(labelptr, XPoint *, objinstptr);
extern void calcbboxsingle(genericptr *, objinstptr, short *, short *, short *, short *);
extern Boolean object_in_library(short, objectptr);
extern short find_object(objectptr, objectptr);
extern void updatepagebounds(objectptr);
extern void calcbbox(objinstptr);
extern void calcbboxparam(objectptr, int);
extern void singlebbox(genericptr *);
extern void calcbboxselect();
extern void calcbboxvalues(objinstptr, genericptr *);
extern void centerview(objinstptr);
extern void refresh(xcWidget, caddr_t, caddr_t);
extern void zoomview(xcWidget, caddr_t, caddr_t);
extern void UDrawSimpleLine(XPoint *, XPoint *);
extern void UDrawLine(XPoint *, XPoint *);
extern void UDrawCircle(XPoint *, u_char);
extern void UDrawX(labelptr);
extern void UDrawXDown(labelptr);
extern int  toplevelwidth(objinstptr, short *);
extern int  toplevelheight(objinstptr, short *);
extern void extendschembbox(objinstptr, XPoint *, XPoint *);
extern void pinadjust(short, short *, short *, short);
extern void UDrawTextLine(labelptr, short);
extern void UDrawTLine(labelptr);
extern void UDrawXLine(XPoint, XPoint);
extern void UDrawBox(XPoint, XPoint);
extern void UDrawBBox();
extern void strokepath(XPoint *, short, short, float);
extern void makesplinepath(splineptr, XPoint *);
extern void UDrawSpline(splineptr);
extern void UDrawEditSpline(splineptr);
extern void UDrawPolygon(polyptr);
extern void UDrawArc(arcptr);
extern void UDrawPath(pathptr);
extern void UDrawObject(objinstptr, short, int, pushlistptr *);
extern void TopDoLatex();

/* from help.c: */

extern void showhsb(xcWidget, caddr_t, caddr_t);
extern void printhelppix();
extern void starthelp(xcWidget, caddr_t, caddr_t);
extern void simplescroll(xcWidget, xcWidget, XPointerMovedEvent *);
extern void exposehelp(xcWidget, caddr_t, caddr_t);
extern void printhelp(xcWidget);

/* from keybindings.c */

extern int firstbinding(int);
extern Boolean ismacro(int);
extern Boolean isbound(int, int);
extern Boolean isnbound(int, int, short *);
extern int boundfunction(int, int);
extern int string_to_func(const char *, short *);
extern int string_to_key(const char *);
extern char *binding_to_string(int, int);
extern char *func_to_string(int);
extern char *key_to_string(int);
extern void printeditbindings();
extern int add_vbinding(int, int, short);
extern int add_binding(int, int);
extern int add_keybinding(const char *, const char *);
extern void default_keybindings();
extern int remove_binding(int, int);
extern void remove_keybinding(const char *, const char *);

#ifndef TCL_WRAPPER
extern void mode_rebinding(int, int);
extern void mode_tempbinding(int, int);
#endif

/* from libraries.c: */

extern short findhelvetica();
extern void catreturn();
extern int pageposition(short, int, int, int);
extern short pagelinks();
extern short *pagetotals(int, short);
extern int is_page(objectptr);
extern int is_library(objectptr);
extern void pagecat_op(int, int, int);
extern void pageinstpos(short, short, objinstptr, int, int, int, int);
extern objinstptr newpageinst(objectptr);
extern void computespacing(short, int *, int *, int *, int *);
extern void composepagelib(short);
extern void updatepagelib(short, short);
extern void pagecatmove(int, int);
extern void composelib(short);
extern short finddepend(objinstptr, objectptr **);
extern void cathide();
extern void catvirtualcopy();
extern void catdelete();
extern void catmove(int, int);
extern void copycat();
extern void catalog_op(int, int, int);
extern void changecat();
extern void startcatalog(xcWidget, pointertype, caddr_t);

/* from menucalls.c: */

extern void dotoolbar(xcWidget, caddr_t, caddr_t);
extern void overdrawpixmap(xcWidget);
extern void getgeneric(buttonsave *, xcWidget, void (*getfunction)(), void *);
extern void setgrid(xcWidget, float *);
extern void measurestr(float, char *);
extern void getsnapspace(xcWidget, caddr_t, caddr_t);
extern void getgridspace(xcWidget, caddr_t, caddr_t);
extern void setfloat(xcWidget, float *);
extern void setwidth(xcWidget, float *);
extern void settsize(xcWidget, labelptr);
extern void autoset(xcWidget, xcWidgetList, caddr_t);
extern void autostop(xcWidget, caddr_t, caddr_t);
extern void autoscale(int);
extern void setscaley(xcWidget, float *);
extern void setscalex(xcWidget, float *);
extern void setorient(xcWidget, short *);
extern void setpmode(xcWidget, short *);
extern void setpagesize(xcWidget, XPoint *);
extern void getkern(xcWidget, caddr_t, caddr_t);
extern void setkern(xcWidget, stringpart *);
extern void getdscale(xcWidget, caddr_t, caddr_t);
extern void setdscale(xcWidget, XPoint *);
extern labelptr gettextsize(float **);
extern void gettsize(xcWidget, caddr_t, caddr_t);
extern void setosize(xcWidget, objinstptr);
extern void getosize(xcWidget, caddr_t, caddr_t);
extern void getwirewidth(xcWidget, caddr_t, caddr_t);
extern void setwwidth(xcWidget, void *);
extern void getwwidth(xcWidget, caddr_t, caddr_t);
extern void getfloat(xcWidget, float *, caddr_t);
extern void setfilename(xcWidget, char **);
extern void setpagelabel(xcWidget, char *);
extern void makenewfontbutton();
extern void makenewencodingbutton(char *, char);
extern void togglefontmark(int);
#ifndef TCL_WRAPPER
extern void toggleexcl(xcWidget, menuptr, int);
extern void highlightexcl(xcWidget, int, int);
extern void toolcursor(int);
extern void promptparam(xcWidget, caddr_t, caddr_t);
#endif
extern void stringparam(xcWidget, caddr_t, caddr_t);
extern void toggle(xcWidget, Boolean *, caddr_t);
extern int setelementstyle(xcWidget, u_short, u_short);
extern void setcolorscheme(Boolean);
extern void inversecolor(xcWidget, Boolean *, caddr_t);
extern void togglegrid(u_short);
extern float parseunits(char *);
extern void setgridtype(char *);
extern void getgridtype(xcWidget, pointertype, caddr_t);
extern void newlibrary(xcWidget, caddr_t, caddr_t);
extern int findemptylib();
extern int createlibrary(Boolean);
extern void newpagemenu(xcWidget, pointertype, caddr_t);
extern void makepagebutton();
extern void renamepage(short);
extern void renamelib(short);
extern void setcolormark(int);
extern void setallstylemarks(u_short);
extern polyptr checkforbbox(objectptr);
#ifndef TCL_WRAPPER
extern void setfill(xcWidget, pointertype, caddr_t);
extern void makebbox(xcWidget, pointertype, caddr_t);
extern void setclosure(xcWidget, pointertype, caddr_t);
extern void setopaque(xcWidget, pointertype, caddr_t);
extern void changetool(xcWidget, pointertype, caddr_t);
extern void exec_or_changetool(xcWidget, pointertype, caddr_t);
extern void rotatetool(xcWidget, pointertype, caddr_t);
extern void pantool(xcWidget, pointertype, caddr_t);
#endif
extern int setline(xcWidget, pointertype, caddr_t);
#ifdef TCL_WRAPPER
extern void setcolor(xcWidget, int);
#else
extern void setcolor(xcWidget, pointertype, caddr_t);
#endif
extern void setnewcolor(xcWidget, caddr_t);
extern void addnewcolor(xcWidget, caddr_t, caddr_t);
extern void setfontmarks(short, short);
extern void startparam(xcWidget, pointertype, caddr_t);
extern void startunparam(xcWidget, pointertype, caddr_t);
extern void setdefaultfontmarks();
extern void setjustbit(xcWidget, pointertype, caddr_t);
extern void setpinjustbit(xcWidget, pointertype, caddr_t);
extern void setjust(xcWidget, pointertype, labelptr, short);
extern void setvjust(xcWidget, pointertype, caddr_t);
extern void sethjust(xcWidget, pointertype, caddr_t);
extern void boxedit(xcWidget, pointertype, caddr_t);
extern void locloadfont(xcWidget, char *);
extern void addnewfont(xcWidget, caddr_t, caddr_t);
extern short findbestfont(short, short, short, short);
extern void setfontval(xcWidget, pointertype, labelptr);
extern void setfont(xcWidget, pointertype, caddr_t);
extern void setfontstyle(xcWidget, pointertype, labelptr);
extern void fontstyle(xcWidget, pointertype, caddr_t);
extern void setfontencoding(xcWidget, pointertype, labelptr);
extern void fontencoding(xcWidget, pointertype, caddr_t);
extern void addtotext(xcWidget, pointertype, caddr_t);
extern void position_popup(xcWidget, xcWidget);
extern void border_popup(xcWidget, caddr_t, caddr_t);
extern void color_popup(xcWidget, caddr_t, caddr_t);
extern void fill_popup(xcWidget, caddr_t, caddr_t);
extern void param_popup(xcWidget, caddr_t, caddr_t);
extern Boolean dospecial(void);

/* from netlist.c: */

#ifdef TCL_WRAPPER
extern Tcl_Obj *tclglobals(objinstptr);
extern Tcl_Obj *tcltoplevel(objinstptr);
#endif

extern Boolean RemoveFromNetlist(objectptr, genericptr);
extern labelptr NetToLabel(int, objectptr);
extern void NameToPosition(objinstptr, labelptr, XPoint *);
extern XPoint *NetToPosition(int, objectptr);
extern void invalidate_netlist(objectptr);
extern void remove_netlist_element(objectptr, genericptr);
extern int updatenets(objinstptr);
extern void createnets(objinstptr);
extern void destroynets();
extern Boolean nonnetwork(polyptr);
extern int globalmax();
extern LabellistPtr geninfolist(objectptr, objinstptr, char *);
extern void gennetlist(objinstptr);
extern void gencalls(objectptr);
extern void search_on_siblings(objinstptr, objinstptr, pushlistptr,
		short, short, short, short);
extern void copy_bus(Genericlist *, Genericlist *);
extern Genericlist *is_resolved(genericptr *, pushlistptr, objectptr *);
extern Boolean highlightnet(objectptr, objinstptr, int, u_char);
extern int pushnetwork(pushlistptr, objectptr);
extern int onsegment(XPoint *, XPoint *, XPoint *);
extern Boolean neardist(long);
extern Boolean nearpoint(XPoint *, XPoint *);
extern int searchconnect(XPoint *, int, objinstptr, int);
extern Genericlist *translateup(Genericlist *, objectptr, objectptr, objinstptr);
extern Genericlist *addpoly(objectptr, polyptr, Genericlist *);
extern long zsign(long, long);
extern Boolean mergenets(objectptr, Genericlist *, Genericlist *);
extern void removecall(objectptr, CalllistPtr);
extern Genericlist *addpin(objectptr, objinstptr, labelptr, Genericlist *);
extern void addcall(objectptr, objectptr, objinstptr);
extern void addport(objectptr, Genericlist *);
extern Boolean addportcall(objectptr, Genericlist *, Genericlist *);
extern void makelocalpins(objectptr, CalllistPtr, char *);
extern int porttonet(objectptr, int);
extern stringpart *nettopin(int, objectptr, char *);
extern Genericlist *pointtonet(objectptr, objinstptr, XPoint *);
extern Genericlist *pintonet(objectptr, objinstptr, labelptr);
extern Genericlist *nametonet(objectptr, objinstptr, char *);
extern Genericlist *new_tmp_pin(objectptr, XPoint *, char *, char *, Genericlist *);
extern Genericlist *make_tmp_pin(objectptr, objinstptr, XPoint *, Genericlist *);
extern void resolve_devnames(objectptr);
extern void resolve_indices(objectptr, Boolean);
extern void clear_indices(objectptr);
extern char *parseinfo(objectptr, CalllistPtr, char *, char *, Boolean);
extern int writedevice(FILE *, char *, objectptr, CalllistPtr, char *);
extern void writeflat(objectptr, CalllistPtr, char *, FILE *, char *);
extern void writeglobals(objectptr, FILE *);
extern void writehierarchy(objectptr, CalllistPtr, FILE *, char *);
extern void writenet(objectptr, char *, char *);
extern Boolean writepcb(struct Ptab **, objectptr, CalllistPtr, char *, char *);
extern void outputpcb(struct Ptab *, FILE *);
extern void freepcb(struct Ptab *);
extern void freegenlist(Genericlist *);
extern void freepolylist(PolylistPtr *);
extern void freelabellist(LabellistPtr *);
extern void freecalls(CalllistPtr);
extern void freenets(objectptr);
extern void freetemplabels(objectptr);
extern void freeglobals();
extern void destroynets(objectptr);
extern int  cleartraversed(objectptr);
extern int  checkvalid(objectptr);
extern void clearlocalpins(objectptr);

/* from parameter.c: */ 

extern char *find_indirect_param(objinstptr, char *);
extern oparamptr match_param(objectptr, char *);
extern oparamptr match_instance_param(objinstptr, char *);
extern oparamptr find_param(objinstptr, char *);
extern int get_num_params(objectptr);
extern void free_object_param(objectptr, oparamptr);
extern void free_instance_param(objinstptr, oparamptr);
extern void free_element_param(genericptr, eparamptr);

extern oparamptr make_new_parameter(char *);
extern eparamptr make_new_eparam(char *);

extern void makeexprparam(objectptr, char *, char *, int);
extern void makefloatparam(objectptr, char *, float);
extern void makestringparam(objectptr, char *, stringpart *);
extern void indicateparams(genericptr);
extern void makenumericalp(genericptr *, u_int, char *);
extern void noparmstrcpy(u_char *, u_char *);
extern void insertparam();
extern void makeparam(labelptr, char *);
extern void searchinst(objectptr, objectptr, char *);
extern stringpart *searchparam(stringpart *);
extern void unmakeparam(labelptr, stringpart *);
extern void unmakenumericalp(genericptr *, u_int);         
extern void unparameterize(int);
extern void parameterize(int, char *);
extern genericptr findparam(objectptr, void *, u_char);
extern Boolean paramcross(objectptr, labelptr);
extern oparamptr parampos(objectptr, labelptr, char *, short *, short *);
extern int opsubstitute(objectptr, objinstptr);
extern int psubstitute(objinstptr);
extern oparamptr copyparameter(oparamptr);
extern void pwriteback(objinstptr);
extern short paramlen(u_char *);
extern int natstrlen(u_char *);
extern int natstrcmp(u_char *, u_char *);
extern void curtail(u_char *);
extern int checklibtop();
extern void removeinst(objinstptr);
extern void removeparams(objectptr);
extern void resolveparams(objinstptr);

/* from python.c: */

#ifdef HAVE_PYTHON
extern void init_interpreter();
extern void exit_interpreter();
#endif

#ifdef HAVE_XPM
extern xcWidget *pytoolbuttons(int *);
#endif

/* from rcfile.c: */

extern short execcommand(short, char *);
extern void defaultscript();
extern void execscript();
extern void loadrcfile();
#ifndef HAVE_PYTHON
extern short readcommand(short, FILE *);
#endif

/* from graphic.c */

extern void UDrawGraphic(graphicptr);
extern Imagedata *addnewimage(char *, int, int);
extern graphicptr new_graphic(objinstptr, char *, int, int);
extern void invalidate_graphics(objectptr);
extern void freegraphic(graphicptr);
extern short *collect_graphics(short *);

/* from flate.c */

#ifdef HAVE_LIBZ
extern unsigned long ps_deflate (unsigned char *, unsigned long,
	unsigned char *, unsigned long);
extern unsigned long ps_inflate (unsigned char *, unsigned long,
	unsigned char **, unsigned long);
#endif

/* from render.c: */

extern void ghostinit();
extern void send_client(Atom);
extern void ask_for_next();
extern void start_gs();
extern void parse_bg(FILE *, FILE *);
extern void bg_get_bbox();
extern void backgroundbbox(int);
extern void readbackground(FILE *);
extern void savebackground(FILE *, char *);
extern void register_bg(char *);
extern void loadbackground();
extern void send_to_gs(char *);
extern int renderbackground();
extern int copybackground();
extern int exit_gs();
extern int reset_gs();

#ifndef TCL_WRAPPER
extern Boolean render_client();
#endif

/* from schema.c: */

extern objectptr NameToPageObject(char *, objinstptr *, int *);
extern objectptr NameToObject(char *, objinstptr *, Boolean);
extern void callwritenet(xcWidget, pointertype, caddr_t);
extern void doxschema(xcWidget, pointertype, caddr_t);
extern void startconnect(xcWidget, caddr_t, caddr_t);
extern void connectivity(xcWidget, caddr_t, caddr_t);
extern Boolean setobjecttype(objectptr);
extern void pinconvert(labelptr, pointertype);
extern void dopintype(xcWidget, pointertype, caddr_t);
extern void setsymschem();
extern int findpageobj(objectptr);
extern void collectsubschems(int);
extern int findsubschems(int, objectptr, int, short *);
extern void copypinlabel(labelptr);
extern int checkschem(objectptr, char *);
extern int checksym(objectptr, char *);
extern void changeotherpins(labelptr, stringpart *);
extern void swapschem(int, int);
extern void dobeforeswap(xcWidget, caddr_t, caddr_t);
extern void schemdisassoc();
extern void startschemassoc(xcWidget, pointertype, caddr_t);
extern Boolean schemassoc(objectptr, objectptr);
#ifndef TCL_WRAPPER
extern void xlib_swapschem(xcWidget, pointertype, caddr_t);
#endif

/* from selection.c: */

extern void selectfilter(xcWidget, pointertype, caddr_t);
extern Boolean checkselect(short);
extern void geneasydraw(short, int, objectptr, objinstptr);
extern void gendrawselected(short *, objectptr, objinstptr);
extern selection *genselectelement(short, u_char, objectptr, objinstptr);
extern short *allocselect();
extern void setoptionmenu();
extern int test_insideness(int, int, XPoint *);
extern Boolean pathselect(genericptr *, short, float);
extern Boolean areaelement(genericptr *);
extern void selectarea();
extern void startdesel(xcWidget, caddr_t, caddr_t);
extern void deselect(xcWidget, caddr_t, caddr_t);
extern void draw_normal_selected();
extern void draw_all_selected();
extern void clearselects_noundo();
extern void clearselects();
extern void unselect_all();
extern selection *recurselect(short, u_char, pushlistptr *);
extern short *recurse_select_element(short, u_char);
extern void startselect();
extern void trackselarea();

/* from text.c: */

extern Boolean hasparameter(labelptr);
extern void drawparamlabels(labelptr, short);
extern stringpart *nextstringpart(stringpart *, objinstptr);
extern stringpart *makesegment(stringpart **, stringpart *);
extern stringpart *splitstring(int, stringpart **, objinstptr);
extern stringpart *mergestring(stringpart *);
extern stringpart *linkstring(objinstptr, stringpart *, Boolean);
extern int findcurfont(int, stringpart *, objinstptr);
extern stringpart *findtextinstring(char *, int *, stringpart *, objinstptr);
extern stringpart *findstringpart(int, int *, stringpart *, objinstptr);
extern void charprint(char *, stringpart *, int);
extern char *stringprint(stringpart *, objinstptr);
extern char *textprint(stringpart *, objinstptr);
extern char *textprintsubnet(stringpart *, objinstptr, int);
extern char *textprintnet(char *, char *, Genericlist *);
extern int textcomp(stringpart *, char *, objinstptr);
extern int textncomp(stringpart *, char *, objinstptr);
extern int stringcomp(stringpart *, stringpart *);
extern int stringcomprelaxed(stringpart *, stringpart *, objinstptr);
extern int stringparts(stringpart *);
extern int stringlength(stringpart *, Boolean, objinstptr);
extern stringpart *stringcopy(stringpart *);
extern stringpart *stringcopyall(stringpart *, objinstptr);
extern stringpart *stringcopyback(stringpart *, objinstptr);
extern stringpart *deletestring(stringpart *, stringpart **, objinstptr);
extern Genericlist *break_up_bus(labelptr, objinstptr, Genericlist *);
extern int sub_bus_idx(labelptr, objinstptr);
extern Boolean pin_is_bus(labelptr, objinstptr);
extern int find_cardinal(int, labelptr, objinstptr);
extern int find_ordinal(int, labelptr, objinstptr);

extern short UDrawChar(u_char, short, short, int, int);
extern void UDrawString(labelptr, int, objinstptr);
extern TextExtents ULength(stringpart *, objinstptr, float, short, XPoint *);
extern void undrawtext(labelptr);
extern void redrawtext(labelptr);
extern void composefontlib(short);
extern void fontcat_op(int, int, int);

/* from xcircuit.c: */

extern void printeventmode();
extern void Wprintf(char *);
extern void popupprompt(xcWidget, char *, char *, void (*function)(),
                        buttonsave *, const char *);
extern void getproptext(xcWidget, propstruct *, caddr_t);
extern int rgb_alloccolor(int, int, int);
extern void addtocolorlist(xcWidget, int);
extern void addnewcolorentry(int);
extern int xc_getlayoutcolor(int);
extern void outputpopup(xcWidget, caddr_t, caddr_t);
extern void docommand();
extern void W1printf(char *);
extern void W2printf(char *);
extern void destroypopup(xcWidget, popupstruct *, caddr_t);
extern int xc_alloccolor(char *);
extern void dointr(int);
extern void DoNothing(xcWidget, caddr_t, caddr_t);
extern u_short countchanges(char **);
extern void quitcheck(xcWidget, caddr_t, caddr_t);
extern void quit(xcWidget, caddr_t);
extern void resizetoolbar();
extern void writescalevalues(char *, char *, char *);
#ifdef TCL_WRAPPER
extern Tcl_Obj *Tcl_NewHandleObj();
extern int Tcl_GetHandleFromObj(Tcl_Interp *, Tcl_Obj *, void **);
#else
extern void updatetext(xcWidget, xcWidgetList, caddr_t);
extern void delwin(xcWidget, popupstruct *, XClientMessageEvent *);
#endif

extern void makecursors();
