#------------------------------------------------------
# Text regexp manipulation (refresh required afterward)
#
# The core routine text_regexp takes either the selected
# items or all items, searches them for text labels, and
# makes the text replacement according to the regular
# expression "searchstr" and the replacement text "replacestr".
#
# (This needs a GUI interface!)
#------------------------------------------------------

proc text_regexp {searchstr replacestr {mode all}} {
   switch $mode {
      selected {set partlist [select get]}
      default {deselect; set partlist [object parts]}
   }
   foreach j $partlist {
      if {[element $j type] == "Label"} {
	 set labelparts [lindex [label $j list] 0]
	 set newparts {}
         set modified 0
	 foreach k $labelparts {
	    if {[lindex $k 0] == "Text"} {
	       set tstring [lindex $k 1]
	       set newt [regsub [list $searchstr] $tstring $replacestr]
	       set newk [lreplace $k 1 1 $newt]
	       lappend newparts $newk
	       if {"$newt" != "$tstring"} {set modified 1}
	    } else {
	       lappend newparts $k
	    }
	 }
	 if {$modified == 1} {
	    label $j replace $newparts
	 }
      }
   }
}

#------------------------------------------------------

