#---------------------------------------------------------------------------
# files.tcl ---
#
#	xcircuit Tcl script for handling multiple-file writes
#
#	Tim Edwards 12/5/05 for MultiGiG
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Forced write all
#---------------------------------------------------------------------------

proc xcircuit::forcewriteall {} {
   set pages [page links all]
   for {set i 1} {$i <= $pages} {incr i} {
      page $i changes 1
   }
   destroy .writeall
   xcircuit::promptwriteall
}

#---------------------------------------------------------------------------
# Write all pages.  Determine which pages are enabled/disabled in the
# ".writeall" window, and save each one.
#---------------------------------------------------------------------------

proc xcircuit::writeall {} {
   global XCOps

   if {![catch {raise .writeall}]} {
      set rows [lindex [grid size .writeall.list] 1]
      incr rows -1
      for {set i 1} {$i <= $rows} {incr i} {
	 if {$XCOps(cbox${i}) > 0} {
	    set pagelist [pack slaves .writeall.list.pframe${i}]
	    set firstpage [lindex $pagelist 0]
	    set pageno [${pagelist} cget -text]
	    page ${pageno} saveonly
	 }
	 unset XCOps(cbox${i})
      }
      destroy .writeall
   }
}

#---------------------------------------------------------------------------
# Prompt for writing all pages
#---------------------------------------------------------------------------

proc xcircuit::promptwriteall {} {
   global XCOps

   # Get list of unique filenames.

   set pages [page links all]
   set filelist {}
   for {set i 1} {$i <= $pages} {incr i} {
      set changes [page $i changes]
      if {$changes > 0} {
         lappend filelist [page $i filename]
      }
   }
   set filelist [lsort -unique -dictionary $filelist]

   # Set up the "writeall" window

   catch {destroy .writeall}
   toplevel .writeall -bg beige
   frame .writeall.tbar -bg beige
   frame .writeall.list -bg beige
   frame .writeall.bbar -bg beige

   pack .writeall.tbar -side top -padx 5 -pady 5 -fill x
   pack .writeall.list -side top -padx 5 -pady 5 -fill x
   pack .writeall.bbar -side top -padx 5 -pady 5 -fill x

   if {[llength $filelist] == 0} {
      label .writeall.tbar.title -text "(No modified pages to write)" -bg \
		beige -fg gray40
      pack .writeall.tbar.title -side left
   } else {
      label .writeall.tbar.title -text "Write All Modified Pages:" -bg beige -fg blue
      pack .writeall.tbar.title -side left

      label .writeall.list.ftitle -text "Filename" -bg beige -fg brown
      label .writeall.list.ptitle -text "Pages" -bg beige -fg brown
      label .writeall.list.wtitle -text "Write?" -bg beige -fg brown
      grid .writeall.list.ftitle -row 0 -column 0 -sticky news
      grid .writeall.list.ptitle -row 0 -column 1 -sticky news
      grid .writeall.list.wtitle -row 0 -column 2 -sticky news
   }

   set k 0
   foreach j $filelist {
      incr k
      label .writeall.list.f${k} -text "$j" -anchor w -bg beige
      frame .writeall.list.pframe${k} -bg beige
      set XCOps(cbox${k}) 1
      checkbutton .writeall.list.cbox${k} -bg beige -variable XCOps(cbox${k})

      set l 0
      for {set i 1} {$i <= $pages} {incr i} {
	 if {[page $i filename] == $j} {
            set changes [page $i changes]
            if {$changes > 0} {
	       incr l
	       button .writeall.list.pframe${k}.b${l} -text "$i" -bg \
			white -command "page goto $i ; \
			promptsavepage"
	       pack .writeall.list.pframe${k}.b${l} -side left -padx 5
	    }
         }
      }
      grid .writeall.list.f${k} -row $k -column 0 -sticky news
      grid .writeall.list.pframe${k} -row $k -column 1 -sticky news
      grid .writeall.list.cbox${k} -row $k -column 2 -sticky news
   }

   if {[llength $filelist] > 0} {
      button .writeall.bbar.okay -text Write -bg beige -command \
		{xcircuit::writeall}
   } else {
      button .writeall.bbar.okay -text Force -bg beige -command \
		{xcircuit::forcewriteall}
   }
   button .writeall.bbar.cancel -text Cancel -bg beige -command \
	{destroy .writeall}

   pack .writeall.bbar.okay -side left -ipadx 10 -padx 5
   pack .writeall.bbar.cancel -side right -ipadx 10 -padx 5
}

