#!/usr/bin/perl
#
# make-dip-lib.pl
# Bryce Denney <bryce@tlw.com>
#
# Quick hack that creates Xcircuit libraries for the standard 74xx 
# DIP series, based on templates.

$dipdefs = "TTL_74xx_DIL.m4";
$diplib = "diptemplate.lps";
$max_titles = 4;
$title_cols = 14;
$title_lines = 4;
$max_per_lib = 50;
$lib_header = <<EOF;
%! PostScript set of library objects for XCircuit
%  Version: 2.3
%  Library name is: diplibN
%  Author: Bryce Denney <bryce\@tlw.com>
%

% XCircuitLib library objects
EOF

$lib_footer = <<EOF2;
% EndLib
EOF2

open (DEFS, "$dipdefs");
open (INLIB, "$diplib");
$outlib_fmt = "diplib%d.lps";
$outlib_num = 0;
$parts_in_this_lib = -1;

# read entire inlib, grab templates into strings
undef $in_template;
while (<INLIB>) {
  if (/^\/TEMPLATE([0-9]+)/) {
    $in_template = $1;
    print "start TEMPLATE$in_template\n";
  } elsif (defined $in_template && /^endgate/) {
  } elsif (/% EndLib/) {
    # don't emit until the very end 
    next;
  }
  if (defined $in_template) {
    $template{$in_template} .= $_;
    if (/^} def/) {
      print "end of TEMPLATE$in_template\n";
      undef $in_template;
    }
  }
}

foreach (keys %template) {
  print "I know how to make $_ pin chips now\n";
}

# now scan dipdefs and emit symbols based on the template.
while (<DEFS>) {
  if ($parts_in_this_lib < 0 || $parts_in_this_lib > $max_per_lib) {
    print OUTLIB $lib_footer;
    close OUTLIB;
    $file = sprintf ($outlib_fmt, $outlib_num);
    open (OUTLIB, ">$file") || die "open $file";
    print OUTLIB $lib_header;
    $outlib_num++;
    $parts_in_this_lib = 0;
  }
  if (/define\(`Param1_([0-9]+)_dil', *([0-9]+)/) {
    print "Found number of pins for $1\n";
    $npins{$1} = $2;
  } elsif (/define\(`Description_([0-9]+)_dil', *``([^']+)/) {
    print "Found description of $1: $2\n";
    $description{$1} = $2;
  } elsif (/define\(`PinList_([0-9]+)_dil', *`(.*)/) {
    print "Found a pin list for $1\n";
    $name = $1;
    $_ = $2;
    s/[`' ]//g;
    @pins = split(/,/);
    print "read ", $#pins+1, " pins for the $name\n";
    die "pin number mismatch" unless $npins{$name} == ($#pins+1);
    $tmpl = $template{$#pins+1};
    die "no template for this package" unless defined $tmpl;
    $part = &emit_part ($tmpl, $name, $description{$name});  # use @pins global variable
    print OUTLIB "$part\n";
    $parts_in_this_lib++;
  } 
}
print OUTLIB $lib_footer;

sub emit_part {
  ($tmpl, $chipname, $descr) = @_;
  $pin_n = 0;
  $tmpl =~ s/74xx/$chipname/g;
  $tmpl =~ s/TEMPLATE[0-9]+/DIP$chipname/g;
  @titles = word_wrap_descr ($descr);
  print "FIXME!\n";
  for ($i=0; $i<$max_titles; $i++) {
    print "Substitute $titles[$i] for title$i.\n";
    if (length $titles[$i]) {
      $tmpl =~ s/title$i/$titles[$i]/g;
    } else {
      $tmpl =~ s/title$i//g;
    }
  }
  print "FIXME2!\n";
  foreach $name (@pins) {
    print "pin $pin_n is called $name\n";
    $pin_n++;
    $tmpl =~ s/pin$pin_n\)/$name)/g;
  }
  print "after pin renaming, we have {$tmpl}\n";
  return $tmpl;
}

sub word_wrap_descr {
  ($descr) = @_;
  $col = 0;
  $line = 0;
  undef @lines;
  @words = split(/[ \-]/, $descr);
  print "WORD_WRAP_DESCR with descr=$descr\n";
  foreach $word (@words) {
    $word =~ s/\//\\\//g;
    if ($word =~ /[^A-Za-z0-9\/]/) {
      print "WARNING: word '$word' may have illegal chars\n";
      $word =~ s/[^A-Za-z0-9\/]//g;
    }
    print "Try to place '$word', length ", length($word), " at col=$col, line=$line\n";
    print "fits on line = ", ($col + length($word)), " < ", $title_cols, "\n";
    if ($col==0 || (($col + length($word)) < $title_cols)) {
      # put on current line.
      print "Put '$word' at col=$col, line=$line\n";
      $lines[$line] .= $word . " ";
      $col += length($word) + 1;
    } elsif ($line <= $title_lines) {
      # put at start of next line.
      $line++; $col = 0;
      print "Didn't fit on current line. Put '$word' at col=$col, line=$line\n";
      $lines[$line] .= $word . " ";
      $col += length($word) + 1;
    } else {
      # doesn't fit.
      print "Warning: skipping 'word' because it doesn't fit.\n"
    }
  }
  return @lines;
}
